<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('webinars', function (Blueprint $table) {
            $table->string('link')->after('slug')->nullable();
            $table->string('guest')->after('slug')->nullable();
            $table->string('location')->after('slug')->nullable();
            $table->tinyInteger('type')->after('slug')->default(1)->comment('1=>Online, 2=>Offline');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('webinars', function (Blueprint $table) {
            $table->string('link')->after('slug')->nullable();
            $table->string('guest')->after('slug')->nullable();
            $table->string('location')->after('slug')->nullable();
            $table->tinyInteger('type')->after('slug')->default(1)->comment('1=>Online, 2=>Offline');
        });
    }
};
