<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->tinyInteger('is_trending')->before('course_status_id')->default(0)->comment('1=>Yes, 0=>No');
            $table->tinyInteger('provide_certificate')->before('course_status_id')->default(1)->comment('1=>Yes, 0=>No');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->tinyInteger('is_trending')->after('status')->default(0)->comment('1=>Yes, 0=>No');
        });
    }
};
