<?php

use App\Models\BillType;
use App\Models\BranchStudent;
use App\Models\Course;
use App\Models\Branch;
use App\Models\BranchAccount;
use App\Models\CourseBatch;
use App\Models\CourseEnrollment;
use App\Models\Setting;
use App\Models\Session;
use App\Models\Student;
use App\Models\CourseModule;
use App\Models\Teacher;
use Illuminate\Support\Facades\Auth;
use App\Models\CourseModuleResult;
use App\Models\CourseResource;
use App\Models\Faq;

function getStudentsByBranchId($id, $year=null){
    if($year != null){
        $data = BranchStudent::where('branch_id', $id)->where('join_year', $year)->get();
    }
    else{
        $data = BranchStudent::where('branch_id', $id)->get();
    }

    return $data;
}

function getStudentsByCourseId($id){
    $data = CourseEnrollment::where('course_id', $id)->get();
    return $data;
}

function getStudentsByBatchId($id){
    $data = CourseEnrollment::where('batch_id', $id)->where(function ($query) {
        $query->where('status', 1)->orWhere('status', 3);
    })->get();
    return $data;
}

function getCoursesBySessionId($id){
    $data = BranchStudent::select('course_id')->where('session_id', $id)->distinct()->get();
    return $data;
}
function getStudentsBySessionId($id, $year=null){
    $branch_id = getBranchIdByAdmin();
    if($branch_id){
        if($year != null){
            $data = BranchAccount::where('session_id', $id)
                ->where('branch_id', $branch_id)->
                where('bill_year', $year)->get();
        }
        else{
            $data = BranchAccount::where('session_id', $id)
                ->where('branch_id', $branch_id)->get();
        }
    }
    else{
        $data = BranchStudent::where('session_id', $id)->get();
    }

    return $data;
}

function getBillBySessionId($id, $year=null)
{
    $branch_id = getBranchIdByAdmin();
    if($branch_id){
        if($year != null){
            $bills = BranchAccount::where('session_id', $id)
                ->where('branch_id', $branch_id)->
                where('bill_year', $year)->get();
        }
        else{
            $bills = BranchAccount::where('session_id', $id)
                ->where('branch_id', $branch_id)->get();
        }
    }
    else{
        $bills = BranchAccount::where('session_id', $id)->get();
    }

    $sum = 0;
    foreach ($bills as $bill){
        $sum+= $bill->amount;
    }
    return $sum;
}

function getCourseById($id)
{
    $data = Course::find($id);
    return $data;
}
function getBranchById($id)
{
    $data = Branch::find($id);
    return $data;
}

function getBillsByBranchId($id, $year=null){
    if($year!=null){
        $students = BranchAccount::where('branch_id', $id)->where('bill_year', $year)->get();
    }
    else{
        $students = BranchAccount::where('branch_id', $id)->get();
    }

    $sum = 0;
    foreach ($students as $student){
        $sum+= $student->amount;
    }
    return $sum;
}

function getPaymentByBranchId($id, $year=null){
    if($year != null){
        $students = BranchAccount::where('branch_id', $id)->where('bill_year', $year)->get();
    }
    else{
        $students = BranchAccount::where('branch_id', $id)->get();
    }
    $sum = 0;
    foreach ($students as $student){
        $sum+= $student->payment;
    }
    return $sum;
}


function getBranchIdByAdmin()
{
    $branch = null;
    if(Auth::user()->role == 2){
        $branch = Branch::where('branch_code', Auth::user()->branch_code)->first();
        return $branch->id;
    }
    else{
        return null;
    }

}

function getStudents($year=null)
{
    if(Auth::user()->role == 4){
        $teacher = Teacher::where('user_id', Auth::user()->id)->first();
        $courses = CourseBatch::where('teacher_id', $teacher->id)->pluck('id')->toArray();
        $students = CourseEnrollment::whereIn('batch_id', $courses)->get();
        return $students;
    }
    $branch_id = getBranchIdByAdmin();
    if($year != null and $branch_id == null ){
        $students = BranchStudent::where('join_year', $year)->get();
    }
    elseif ($year == null and $branch_id != null ) {
        $students = BranchStudent::where('branch_id', $branch_id)->get();
    }
    elseif ($year != null and $branch_id != null ) {
        $students = BranchStudent::where('branch_id', $branch_id)
            ->where('join_year', $year)->get();
    }
    else{
        $students = BranchStudent::all();
    }

    return $students;
}

function getBills($year=null){
    $branch_id = getBranchIdByAdmin();

    if($year != null and $branch_id == null){
        $students = BranchAccount::where('bill_year', $year)->get();
    }
    elseif ($year == null and $branch_id != null ) {
        $students = BranchAccount::where('branch_id', $branch_id)->get();
    }
    elseif ($year != null and $branch_id != null ) {
        $students = BranchAccount::where('branch_id', $branch_id)
            ->where('bill_year', $year)->get();
    }
    else{
        $students = BranchAccount::all();
    }
    $sum = 0;
    foreach ($students as $student){
        $sum+= $student->amount;
    }
    return $sum;
}

function getPayments($year=null){
    $branch_id = getBranchIdByAdmin();

    if($year != null and $branch_id == null){
        $students = BranchAccount::where('bill_year', $year)->get();
    }
    elseif ($year == null and $branch_id != null ) {
        $students = BranchAccount::where('branch_id', $branch_id)->get();
    }
    elseif ($year != null and $branch_id != null ) {
        $students = BranchAccount::where('branch_id', $branch_id)
            ->where('bill_year', $year)->get();
    }
    else{
        $students = BranchAccount::all();
    }
    $sum = 0;
    foreach ($students as $student){
        $sum+= $student->payment;
    }
    return $sum;
}

function getActiveSessions()
{
    $data = Session::where('session_status_id', 1)->get();
    return $data;
}

function getSettings($key){
    $setting = Setting::where('key', $key)->first();
    if(!$setting){
        return '';
    }
    return $setting->value;
}
function getStudentById($id)
{
    $data = Student::find($id);
    return $data;
}
function getBranchStudentById($id)
{
    $data = BranchStudent::find($id);
    return $data;
}

function getBranchStudentByStudentId($id){
    $data = BranchStudent::where('student_id', $id)->first();
    return $data;
}

function feeCalculation($request)
{
    $course = Course::find($request->course_id);
    $fee = $course->course_fee;
    $billTypes = BillType::all();

    foreach ($billTypes as $bill){
        $fee+= $bill->bill_amount;
    }

    return $fee;
}

function getCourseModuleByCourseId($id)
{
    $data = CourseModule::where('course_id', $id)->get();
    return $data;
}
function getModuleResultByStudentId($id)
{
    $data= CourseModuleResult::where('student_id', $id)->get();
    return $data;
}
function findCategoryCourse($id){
    $courses = Course::where('category_id', $id)->where('course_status_id', 1)->get();
    return $courses;
}

function findUser(){
    $user = Auth::user();
    if(Auth::user()->role == 3){
        $user = Student::where('user_id', Auth::user()->id)->first();
    }
    return $user;

}

function getEnrolledCourses(){
    $user = Student::where('user_id', Auth::user()->id)->first();
    if(Auth::user()->role == 3){
        $courses = CourseEnrollment::where('student_id', $user->id);
    }
    return $courses;
}

function getCourseContent($id){
    return CourseResource::where('course_id', $id)->get();
}

function findEnrollment($id){
    $user = Student::where('user_id', Auth::user()->id)->first();
    return CourseEnrollment::where('course_id', $id)->where('student_id', $user->id)->where('status', 1)->first();
}
function getEnrollmentBills(){
    return CourseEnrollment::where('status', 1)->sum('total_fee');
}

function getCourseEnrollments($id){
    return CourseEnrollment::where('course_id', $id)->where('status', 1)->get();
}
function countFaq($id){

    return count(Faq::where('course_id', $id)->get());
}
function assignedBatches(){
    $teacher = Teacher::where('user_id', Auth::user()->id)->first();
    $batches = CourseBatch::where('teacher_id', $teacher->id)->get();
    return $batches;
}

function assignedCourses(){
    $teacher = Teacher::where('user_id', Auth::user()->id)->first();
    $courses = CourseBatch::select('course_id')->where('teacher_id', $teacher->id)->distinct()->get();

    return $courses;
}
function getAssignedBatchesByCourseId($id){
    $teacher = Teacher::where('user_id', Auth::user()->id)->first();
    return CourseBatch::where('course_id', $id)->where('teacher_id', $teacher->id)->orderBy('course_id', 'asc')->get();
}
function getContent($key){
    return \App\Models\Page::where('key', $key)->first()->value ?? '';
}

function classThisMonth()
{
    $total_class= \App\Models\ClassSchedule::where('teacher_id', Auth::user()->id)->whereMonth('date', date('m'))->count();
    return $total_class;
}

function todaysClasses()
{
    $total_class= \App\Models\ClassSchedule::where('teacher_id', Auth::user()->id)->where('date', date('Y-m-d'))->count();
    return $total_class;
}

function attendancePercentage()
{
   $total_classes= \App\Models\ExamAttendance::where('teacher_user_id', Auth::user()->id)->get();
   if(count($total_classes) > 0){
       $avg=0;
       foreach ($total_classes as $class){
           $avg += $class->present/$class->total_student;
       }
       return $avg/count($total_classes)*100;
   }
   else{
       return 0;
   }
}

if (!function_exists('getLastEnrollmentId')) {
    function getLastEnrollmentId() {
        $enrollment = CourseEnrollment::orderBy('id', 'desc')->first();
        if($enrollment) {
            return $enrollment->id;
        }
        return 0;
    }
}

if (!function_exists('getLastCourseCode')) {
    function getLastCourseCode() {
        $course = Course::orderBy('id', 'desc')->first();
        if($course) {
            return $course->course_code;
        }
        return 0;
    }
}
