<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class WebinarBooking extends Model
{
    use HasFactory;

    private static $booking;

    public static function add($request)
    {
        self::$booking = new WebinarBooking();
        $webinar = Webinar::findOrFail($request->webinar_id);
        self::$booking->name        = $request->name;
        self::$booking->email       = $request->email;
        self::$booking->phone       = $request->phone;
        self::$booking->address     = $request->address;
        self::$booking->webinar_id  = $request->webinar_id;
        self::$booking->course_id   = $webinar->course_id;
        self::$booking->save();
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function webinar(){
        return $this->belongsTo(Webinar::class, 'webinar_id');
    }


}
