<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Student;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    public static function addOrUpdate($request){
        $student = Student::find($request->id);
        // dd($student);
        if($student){
            $user = User::find($student->user_id);
        }
        else{
            $user = new User();
        }
//        dd($request);
        $user->name = $request->student_name;
        $user->email = $request->student_email;
        $user->phone = $request->student_phone;
        $user->password = bcrypt($request->password);
        $user->role = 3;
        $user->save();
        return $user;
    }
    public static function addNewStudent($request){

            $user = new User();

        $user->name = $request['student_name'];
        $user->email = $request['student_email'];
        $user->password = bcrypt($request['password']);
        $user->role = 3;
        $user->save();
        return $user;
    }
    public static function updateProfile($request){
        $user = User::find($request->id);

        $user->name = $request->name;
        $user->email = $request->email;
        if($user->role == 1){
            if ($request->file('image')) {
                if ($user->image) {
                    if (file_exists($user->image)) {
                        unlink($user->image);
                    }
                    $user->image = self::saveImageUrl($request);
                }
                else {
                    $user->image = self::saveImageUrl($request);
                }
            }
        }
        $user->save();
    }

    public static function updatePassword($request){
        User::find($request->id)->update(['password' => bcrypt($request->password)]);
    }

    private static function saveImageUrl($request){
        $image = $request->file('image');
        $imageName = $request->name. '.' . $image->extension();
        $directory = 'uploads/admin/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }

    public function teacher()
    {
        return $this->belongsTo(Teacher::class, 'id', 'user_id');
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'id', 'user_id');
    }
}
