<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
class Testimonial extends Model
{
    use HasFactory;

    private static $testimonial, $branchStudent;

    public static function addOrUpdate($request)
    {

        if (Testimonial::find($request->id)) {
            self::$testimonial = Testimonial::find($request->id);
            $request->student_id = self::$testimonial->student_id;
            $request->course_id = self::$testimonial->course_id;
            $request->rating = self::$testimonial->rating;
        }
        else {
            self::$testimonial = new Testimonial();
        }
        if(Auth::user()->role == 3){
            $student = Student::where('user_id', Auth::user()->id)->first();
            self::$testimonial->image   = $student->student_image;
        }

        self::$testimonial->name        = $request->name;
        self::$testimonial->profession  = $request->profession ?? 'Student';
        self::$testimonial->description = $request->description;
        self::$testimonial->status      = $request->status ?? 0;
        self::$testimonial->course_id   = $request->course_id;
        self::$testimonial->rating      = $request->rating;
        self::$testimonial->student_id  = $student->id ?? null;

        if ($request->file('image')) {
            if (self::$testimonial->image) {
                if (file_exists(self::$testimonial->image)) {
                    unlink(self::$testimonial->image);
                }
                self::$testimonial->image = self::saveImageUrl($request);
            } else {
                self::$testimonial->image = self::saveImageUrl($request);
            }
        }
        self::$testimonial->save();
    }

    private static function saveImageUrl($request){

        $image = $request->file('image');
//        dd($image);
        $imageName = date('YmdHis'). rand(1,9999). '.' . $image->extension();
        $directory = 'uploads/testimonial/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }

    public static function remove($id)
    {
        self::$testimonial = Testimonial::find($id);
        if (self::$testimonial->image){
            unlink(self::$testimonial->image);
        }
        self::$testimonial->delete();
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
}
