<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Faq extends Model
{
    use HasFactory;
    private static $faq;

    public static function add($request){

        for($i=0; $i<count($request->question); $i++){
            self::$faq = new Faq();

            self::$faq->course_id = $request->course_id;
            self::$faq->question = $request->question[$i];
            self::$faq->answer = $request->answer[$i];
            self::$faq->save();
        }

    }

    public static function change($request){
        Faq::where('course_id', $request->course_id)->delete();
        self::add($request);
    }

    public static function remove($id){
        Faq::where('course_id', $id)->delete();
    }

    public function course(){
        return $this->belongsTo(Course::class, 'course_id', 'id');
    }
}
