<?php

namespace App\Models;

use FontLib\Table\Type\name;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class CourseResource extends Model
{
    use HasFactory;
    private static $resource;
    private static $otherImage, $fileName, $directory, $fileUrl;

    public static function add($request, $id)
    {
        // dd($request);
        if(isset($request->video) && count($request->video) > 0){
            foreach ($request->video as $key=> $item){
                self::$resource = new CourseResource();
                self::$resource->course_id = $id;
                self::$resource->type = 'video';
                self::$resource->title = $request->video_title[$key];
                self::$resource->resource = $item;
                self::$resource->save();
            }
        }
        if(isset($request->discussion) && count($request->discussion) > 0){
            foreach ($request->discussion as $key=> $item){
                self::$resource = new CourseResource();
                self::$resource->course_id = $id;
                self::$resource->type = 'discussion';
                self::$resource->title = $request->discussion_title[$key];
                self::$resource->resource = $item;
                self::$resource->save();
            }
        }
        if(isset($request->note) && count($request->note) > 0){
            // dd($request->note);
            foreach ($request->note as $item){
                self::$resource = new CourseResource();
                self::$resource->course_id = $id;
                self::$resource->type = 'note';
                self::$resource->resource = self::saveFilePath($item, $request->course_name);
                self::$resource->save();
            }
        }
    }

    public static function change($request)
    {
//         dd($request);
        if(isset($request->noteCheck) && count($request->noteCheck) > 0){
            foreach(CourseResource::where('course_id', $request->id)->where('type', 'note')->get() as $resource){
                if(in_array($resource->id, $request->noteCheck)){

                }
                else{
                    unlink($resource->resource);
                    $resource->delete();
                }
            }
        }
        else{
            CourseResource::where('course_id', $request->id)->where('type', 'note')->delete();
        }
        CourseResource::where('course_id', $request->id)->where('type', 'video')->delete();
        CourseResource::where('course_id', $request->id)->where('type', 'discussion')->delete();
        self::add($request, $request->id);
    }

    private static function saveFilePath($file, $courseName)
    {

        $fileName = $courseName . '-' . rand(1000, 9999) . '.' . $file->extension();
        $directory = 'uploads/course-files/';
        $filePath = $directory . $fileName;

        // Ensure the directory exists
        if (!Storage::exists($directory)) {
            Storage::makeDirectory($directory);
        }

        // Move the file to the specified directory
        $file->move(public_path($directory), $fileName);

        return $filePath;
    }

    public static function remove($id){
        foreach (CourseResource::where('course_id', $id)->where('type', 'note')->get() as $item){
            unlink($item->resource);
        }
        self::$resource = CourseResource::where('course_id', $id)->delete();
    }
}
