<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseProject extends Model
{
    use HasFactory;

    private static $project;

    public static function add($request, $course_id){
        if(isset($request->projects)){
            $total_project = count($request->projects);
        }
        else{
            $total_project = 0;
        }
        for($i=0; $i<$request->project - $total_project; $i++){
            self::$project = new CourseProject();
            self::$project->course_id = $course_id;
            self::$project->name = $request->project_name[$i];
            self::$project->description = $request->project_description[$i];

            self::$project->thumbnail = self::saveImageUrl($request->project_thumbnail[$i]);

            self::$project->save();
        }
    }

    public static function change($request)
    {
        for($i=0; $i<count($request->projects); $i++){
            self::$project = CourseProject::find($request->projects[$i]);
            self::$project->name = $request->existing_project_name[$i];
            self::$project->description = $request->existing_project_description[$i];
            $file = 'existing_project_thumbnail'. $request->projects[$i];
            if ($request->file($file)) {
//                 dd('ok');
                if (self::$project->thumbnail) {
                    if (file_exists(self::$project->thumbnail)) {
                        unlink(self::$project->thumbnail);
                    }
                    self::$project->thumbnail = self::saveImageUrl($request->$file);
                } else {
                    self::$project->thumbnail = self::saveImageUrl($request->$file);
                }
            }

//            self::$project->thumbnail = self::saveImageUrl($request->existing_thumbnail[$i]);

            self::$project->save();
        }


    }

    private static function saveImageUrl($request){
        $image = $request;
        $imageName = 'project'.date('ymdhis').rand(000, 999999). '.' . $image->extension();
        $directory = 'uploads/courses/projects/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }

    public static function remove($id)
    {
        self::$project = CourseProject::where('course_id', $id)->get();
        foreach (self::$project as $project) {
            if (file_exists($project->thumbnail)) {
                unlink($project->thumbnail);
            }
            $project->delete();
        }
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
}
