<?php

namespace App\Models;

use Illuminate\Bus\Batch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseEnrollment extends Model
{
    use HasFactory;
    private static $course_enroll;
    public static function add($request, $student_id)
    {
        if (CourseEnrollment::find($request->id)) {
            self::$course_enroll = CourseEnrollment::find($request->id);
        } else {
            self::$course_enroll = new CourseEnrollment();
        }
        $course = Course::find($request->course_id);
        if($request->batch_id_online != Null){
            // dd($request->batch_id_online);
            $batch = CourseBatch::find($request->batch_id_online);
        }
        if($request->batch_id != Null){
            $batch = CourseBatch::find($request->batch_id);
        }
        if ($request->branch_id != Null) {
            $branch = Branch::find($request->branch_id);
        }
        // dd($branch);
        // $student_id = Student::where('user_id', Auth::user()->id);

        // dd($request);

        self::$course_enroll->student_id                = $student_id;
        self::$course_enroll->payment_number            = $request->payment_number;
        self::$course_enroll->total_fee                 = $course->course_fee;
        self::$course_enroll->total_paid                = $course->course_fee;
        self::$course_enroll->discount                  = $course->discount;
        self::$course_enroll->due                       = 0;


        self::$course_enroll->course_id                 = $request->course_id;
        self::$course_enroll->session_id                = $batch->session_id;
        if ($request->batch_id_online != Null) {
            // dd($request->batch_id_online);
            self::$course_enroll->batch_id              = $request->batch_id_online;
        }
        if($request->batch_id != Null){
            self::$course_enroll->batch_id              = $request->batch_id;
        }

        if ($request->branch_id != Null) {
            self::$course_enroll->branch_id             = $request->branch_id;
            self::$course_enroll->student_roll          = $branch->branch_code . str_repeat('0', max(0, 5 - strlen($student_id))) . $student_id;
        }
        self::$course_enroll->student_registration      = $course->course_code . self::$course_enroll->student_roll;
        self::$course_enroll->course_type               = $request->course_type ?? $course->course_type;
        self::$course_enroll->payment_method            = $request->payment_method;
        self::$course_enroll->status                    = $request->status ?? 0;


        self::$course_enroll->save();

        return self::$course_enroll;
    }
    
    public static function addNew($request, $student_id)
    {
        // dd($request);
        if (CourseEnrollment::find($request->id)) {
            self::$course_enroll = CourseEnrollment::find($request->id);
        } else {
            self::$course_enroll = new CourseEnrollment();
        }
        $course = Course::find($request->course_id);
        $batch = CourseBatch::find($request->batch);
        $branch = $batch->branch;
        
       
        // dd($branch);
        // $student_id = Student::where('user_id', Auth::user()->id);

        // dd($request);
        
        // dd($request->payment_info);
        
        if($request->discount==null){
            $request->discount = 0;
        }
        if($request->course_fee==null){
            $request->course_fee = 0;
        }
        if($request->total_fee==null){
            $request->total_fee = 0;
        }
        if($request->due==null){
            $request->due = 0;
        }
        if($request->enrolled_by==null){
            $request->enrolled_by = 1;
        }
        
        if($request->total_paid==null){
            $request->total_paid = 0;
        }
        $total_paid = $request->total_paid;
        
        if($request->enrolled_by != 2){
            $total_paid = $request->total_fee - $request->discount;
        }
        

        self::$course_enroll->invoice_no                = $request->invoice_no;
        self::$course_enroll->student_id                = $student_id;
        self::$course_enroll->payment_number            = $request->payment_number;
        self::$course_enroll->course_fee                = $request->course_fee ?? 0;
        self::$course_enroll->total_fee                 = $request->total_fee;
        self::$course_enroll->discount                  = $request->discount ?? 0;
        self::$course_enroll->total_paid                = $total_paid;
        self::$course_enroll->due                       = $request->due ?? 0;


        self::$course_enroll->course_id                 = $request->course_id;
        self::$course_enroll->session_id                = $batch->session_id;
        self::$course_enroll->batch_id                  = $request->batch;

        self::$course_enroll->branch_id                 = $branch->id;
        self::$course_enroll->student_roll              = $branch->branch_code . str_repeat('0', max(0, 5 - strlen($student_id))) . $student_id;
        
        self::$course_enroll->student_registration      = $course->course_code . self::$course_enroll->student_roll;
        self::$course_enroll->course_type               = $request->course_type ?? $course->course_type;
        self::$course_enroll->payment_method            = $request->payment_method;
        self::$course_enroll->status                    = 1;
        self::$course_enroll->enrolled_by               = $request->enrolled_by;
        
        if($request->payment_method == 'bkash'){
            $payment_info = json_decode($request->payment_info);
            
            self::$course_enroll->trx_id                    = $payment_info->trxID;
            self::$course_enroll->trx_account_no            = $payment_info->payerAccount;
            
            self::$course_enroll->payment_details           = $request->payment_info;
        }


        self::$course_enroll->save();

        return self::$course_enroll;
    }

    public static function remove($id)
    {
        self::$course_enroll = CourseEnrollment::find($id);
        self::$course_enroll->delete();
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function branchStudent()
    {
        return $this->belongsTo(BranchStudent::class, 'student_id', 'student_id');
    }
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
    public function batch()
    {
        return $this->belongsTo(CourseBatch::class, 'batch_id');
    }
    public function session()
    {
        return $this->belongsTo(Session::class, 'session_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }
}
