<?php

namespace App\Models;

use App\Models\CourseBatch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class ClassSchedule extends Model
{
    use HasFactory;

    private static $schedule;

    public static function add($request)
    {

        for($i = 0; $i < count($request->date); $i++){
            self::$schedule = new ClassSchedule();

            self::$schedule->teacher_id      = Auth::user()->id;
            self::$schedule->course_id       = $request->course_id;
            self::$schedule->batch_id        = $request->batch_id;
            self::$schedule->link            = $request->link[$i];
            self::$schedule->date            = $request->date[$i];
            self::$schedule->status          = 1;


            self::$schedule->save();
        }
    }

    public static function remove($id)
    {
        self::$schedule = ClassSchedule::find($id);
        self::$schedule->delete();
    }

    public static function endClass($request)
    {
        self::$schedule = ClassSchedule::findOrFail($request->id);
        self::$schedule->status = 2;
        self::$schedule->summary = $request->summary;
        self::$schedule->save();
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function batch(){
        return $this->belongsTo(CourseBatch::class, 'batch_id');
    }
}
