<?php

namespace App\Http\Controllers;

use App\Models\Webinar;
use App\Models\WebinarBooking;
use App\Models\WebinarTopic;
use App\Utility\SmsUtility;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WebinarController extends Controller
{
    private $webiner;
    public function add()
    {
        return view('admin.webinar.form');
    }

    public function submit(Request $request)
    {
//        return $request;
        $this->validation($request);

        $this->webiner = Webinar::addOrUpdate($request);
//        WebinarTopic::add($request, $this->webiner->id);


        return redirect()->route('admin.webinar.list')->with('message', 'Webinar Added Successfully!!');

    }

    public function list()
    {
        $data['items'] = Webinar::latest()->get();
        return view('admin.webinar.list', $data);
    }



    public function edit($id)
    {

        $data['item'] = Webinar::findOrFail($id);
        $data['topics'] = WebinarTopic::where('webinar_id', $id)->get();
        return view('admin.webinar.edit', $data);
    }


    public function update(Request $request)
    {
//        return $request;
        $this->validation($request);
        Webinar::valueUpdate($request);
        WebinarTopic::where('webinar_id', $request->id)->delete();
        WebinarTopic::add($request->topic_1, $request->id);
        return redirect()->route('admin.webinar.list')->with('message', 'Webinar Updated Successfully!!');
    }

    public function remove(Request $request)
    {
        WebinarTopic::where('webinar_id', $request->id)->delete();
        Webinar::remove($request->id);
        return redirect()->route('admin.webinar.list')->with('message', 'Webinar Has Been Removed Successfully!!');
    }

    public function validation($request)
    {
        $request->validate([
            'course_id' => ['required'],
//            'title'     =>['required', 'max:200'],
        ]);

        for($i = 0; $i < $request->webinar_count; $i++){
            $title = 'title_'.$i;
            $date = 'date_'.$i;
            $time = 'time_'.$i;
            $price = 'price_'.$i;
            $topic = 'topic_'.$i;
            $type = 'type_'.$i;
            if(isset($request->$title) || isset($request->$type) ||isset($request->$date) || isset($request->$time) || isset($request->$price) || isset($request->$topic)){
                $request->validate([
                    $date   => ['required'],
                    $time   => ['required'],
                    $price  => ['required'],
                    $topic  => ['required'],
                    $title  => ['required'],
                    $type   => ['required'],
                ]);
            }
        }

    }

    public function sendMessage($id)
    {
        $webinar = Webinar::findOrFail($id);
        if($webinar->type== 1){
            $text='You can join the webinar using link: '. $webinar->link;
        }
        else{
            $text = 'The webinar will held at '.$webinar->location;
        }
       $bookings= WebinarBooking::where('webinar_id', $id)->get();
       foreach($bookings as $booking){
           if(substr($booking->phone,0,3)=="+88"){
               $phone = $booking->phone;
           }elseif(substr($booking->phone,0,2)=="88"){
               $phone = '+'.$booking->phone;
           }else{
               $phone = '+88'.$booking->phone;
           }

           $message = 'Dear '.$webinar->user->name. ', The webinar titled as '. $webinar->title. ' will be held on '. date('d M, Y', strtotime($webinar->date)). ' at '.date('H:i A', strtotime($webinar->time)).' '. $text;
           SmsUtility::sendSMS($phone, $message);
       }
       return back()->with('message', 'Message Sent Successfully!!');
    }

}
