<?php

namespace App\Http\Controllers;

use App\Models\UserMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Anhskohbo\NoCaptcha\Facades\NoCaptcha;

class UserMessageController extends Controller
{
    public function submit(Request $request)
{
    $validator = Validator::make($request->all(), [
        'name' => 'required|string|max:255',
        'email' => 'required|email|max:255',
        'message' => 'required|string',
        'g-recaptcha-response' => 'required|captcha',
    ]);

    if ($validator->fails()) {
        return back()->withErrors($validator)->withInput();
    }

    UserMessage::create($request->only('name', 'email', 'message'));

    return back()->with('message', 'Message Has Been Sent Successfully!!');
}

    public function list()
    {
        $data['items'] = UserMessage::latest()->get();
        return view('admin.message.user-message-list', $data);
    }
}
