<?php

namespace App\Http\Controllers;

use App\Models\Testimonial;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TestimonialController extends Controller
{
    private $testimonial;
    public function add()
    {
        return view('admin.testimonial.form');
    }

    public function submit(Request $request)
    {
//        return $request;
        // $request->name = Auth::user()->name;
        $this->validation($request);
        if(Auth::user()->role == 3){
            $request->validate([
                'rating' => 'required',
            ]);
        }

        $this->testimonial = Testimonial::addOrUpdate($request);

        if(Auth::user()->role == 1){
            return redirect()->route('admin.testimonial.list')->with('message', 'Testimonial Has Been Added Successfully!!');
        }
        else{
            return redirect()->route('student.dashboard')->with('message', 'Testimonial Has Been Submitted Successfully!!');
        }
    }

    public function list()
    {
        $data['items'] = Testimonial::latest()->where('status', 1)->get();
        return view('admin.testimonial.list', $data);
    }

    public function studentList(){
        $data['items'] = Testimonial::where('student_id', '!=' , Null )->where('status', 0)->get();
        return view('admin.testimonial.student.list', $data);
    }

    public function edit($id)
    {

        $data['item'] = Testimonial::find($id);
        return view('admin.testimonial.form', $data);
    }


    public function update(Request $request)
    {
        $this->validation($request);
        Testimonial::addOrUpdate($request);
        return redirect()->route('admin.testimonial.list')->with('message', 'Testimonial Has Been Updated in the Gallery Successfully!!');
    }

    public function remove(Request $request)
    {
        Testimonial::remove($request->id);
        return redirect()->route('admin.testimonial.list')->with('message', 'Testimonial Has Been Removed from the Gallery Successfully!!');
    }

    public function validation($request)
    {
        $request->validate([
            'description'=>['required', 'max:255']
        ]);
        if(Auth::user()->role == 1){
            $request->validate([
                'name'=>['required'],
            ]);
        }
    }
}
