<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\Course;
use App\Models\CourseBatch;
use App\Models\CourseEnrollment;
use App\Models\Student;
use App\Models\Teacher;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TeacherController extends Controller
{
    public $user, $teacher;
    public function add()
    {
        $data['courses'] = Course::where('course_status_id', 1)->orderBy('course_name', 'asc')->latest()->get();
        return view('admin.teacher.form', $data);
    }
    public function submit(Request $request)
    {
//        return $request;
        $request->validate([
            'name'       => ['required'],
            'phone'      => ['required', 'unique:teachers'],
            'email'      => ['unique:users'],
            'designation'   => ['required', 'max:255'],
            'password'   => ['required', 'min:8', 'confirmed'],
            'join_date'  => ['required'],
            'description'=> ['required']
        ]);
        $this->user = $this->addOrUpdateUser($request);
        Teacher::addOrUpdate($request, $this->user->id);
        return redirect()->route('teacher.list')->with('message', 'Teacher Has Been Added SuccessFully!!');
    }

    public function list()
    {
        $data['items'] = Teacher::latest()->paginate(25);
        return view('admin.teacher.list', $data);
    }

    public function edit($id)
    {
        $data['item'] = Teacher::find($id);
        $data['courses'] = Course::where('course_status_id', 1)->orderBy('course_name', 'asc')->latest()->get();
        $data['batches'] = CourseBatch::where('status', 1)->where('course_id', $data['item']->course_id)->latest()->get();
        return view('admin.teacher.form', $data);
    }
    public function update(Request $request)
    {
        $request->validate([
            'name'          => ['required'],
            'phone'         => ['required', 'min:11', 'max:15'],
            'designation'   => ['required', 'max:255'],
            'password'      => ['required', 'min:8'],
            'join_date'     => ['required'],
            'description'=> ['required']
        ]);
        $this->teacher = Teacher::find($request->id);
        Teacher::addOrUpdate($request, $this->teacher->user_id);
        return redirect()->route('teacher.list')->with('message', 'Teacher Information Has Been Updated Successfully!!');
    }
    public function remove(Request $request)
    {
        $this->removeUser($request->id);
        Teacher::remove($request->id);
        return back()->with('message', 'Teacher Has Been Removed Successfully!!');
    }

    private function addOrUpdateUser($request)
    {
        $branch = Branch::where('branch_code', Auth::user()->branch_code)->first();
        if($request->id){
            $this->teacher = Teacher::find($request->id);
            $this->user = find($this->teacher->user_id);
        }
        else{
            $this->user = new User();
            $this->user->name = $request->name;
            $this->user->branch_code = $branch->branch_code ?? 0;
            $this->user->role = 4;
            $this->user->password = bcrypt($request->password);
        }

        $this->user->email = $request->email;
        $this->user->save();
        return $this->user;
    }

    public function removeUser($id)
    {
        $this->teacher = Teacher::find($id);
        $this->user = User::find($this->teacher->user_id);
        $this->user->delete();
    }

    public function getBatchByCourseId()
    {
        return response()->json(CourseBatch::where('course_id', $_GET['course_id'])->where('status', 1)->get());
    }

    public function getBatchByBranchId()
    {
        return response()->json(CourseBatch::where('branch_id', $_GET['branch_id'])->where('status', 1)->get());
    }
    public function getBranchByCourseId()
    {
        $branch = CourseBatch::where('course_id', $_GET['course_id'])->where('status', 1)->pluck('branch_id')->toArray();
        return response()->json(Branch::whereIn('id', $branch)->get());
    }
    
    // public function getBatchByBranchCourseId()
    // {
    //     return response()->json(CourseBatch::where('branch_id', $_GET['branch_id'])->where('course_id', $_GET['course_id'])->where('status', 1)->get());
    // }
    
    public function getBatchByBranchCourseId()
    {
        $batches = CourseBatch::where('branch_id', $_GET['branch_id'])
            ->where('course_id', $_GET['course_id'])
            ->where('status', 1)
            ->get();
    
        $course = Course::find($_GET['course_id']); // Replace this with the actual data you want to return
    
        return response()->json([
            'batches' => $batches,
            'course' => $course
        ]);
    }
    public function getCourseById()
    {
        $course = Course::find($_GET['course_id']); // Replace this with the actual data you want to return
        return response()->json([
            'course' => $course
        ]);
    }

    public function assignedBatches()
    {

        $data['items'] = assignedBatches();
        return view('teacher.batch.list', $data);
    }

    public function assignedCourses()
    {
        $teacher = Teacher::where('user_id', Auth::user()->id)->first();
        $courses = CourseBatch::select('course_id')->where('teacher_id', $teacher->id)->distinct();
        $assigned_course_array = CourseBatch::select('course_id')->where('teacher_id', $teacher->id)->distinct()->pluck('course_id')->toArray();
        if(isset($_GET['course_status_id']) && $_GET['course_status_id'] >= 0){
            $active_courses = Course::where('course_status_id',  $_GET['course_status_id'])->pluck('id')->toArray();
            $courses = $courses->whereIn('course_id', $active_courses);

        }
        if(isset($_GET['course_type']) && $_GET['course_type'] > 0){
            $courses_type = Course::where('course_type', $_GET['course_type'])->pluck('id')->toArray();
            $courses = $courses->whereIn('course_id', $courses_type);
        }
        $data['items'] = $courses->get();
//        dd($data);
        return view('teacher.course.list', $data);
    }

    public function studentList()
    {
        $teacher = Teacher::where('user_id', Auth::user()->id)->first();
        $batches = CourseBatch::where('teacher_id', $teacher->id)->pluck('course_id')->toArray();
        $students = CourseEnrollment::whereIn('course_id', $batches)->latest();
        if(isset($_GET['course_id']) && $_GET['course_id'] >= 0){
            $students = $students->where('course_id', $_GET['course_id']);
            $data['assigned_branches'] = CourseBatch::select('branch_id')->where('teacher_id', $teacher->id)->where('branch_id', '!=', null)->distinct()->get();
//            dd(count($data['']));
        }
        if(isset($_GET['branch_id']) && $_GET['branch_id'] > 0){
            $students = $students->where('branch_id', $_GET['branch_id']);
            $data['batches'] = CourseBatch::where('teacher_id', $teacher->id)->where('course_id', $_GET['course_id'])->get();
        }
        if(isset($_GET['batch_id']) && $_GET['batch_id'] > 0){
            $students = $students->where('batch_id', $_GET['batch_id']);
        }
        $data['items'] = $students->paginate(50);
        return view('teacher.student.list', $data);
    }
    public function studentListByBatch($id)
    {
        $batches = CourseBatch::where('id', $id)->pluck('course_id')->toArray();

        $teacher = Teacher::where('user_id', Auth::user()->id)->first();
        $students = CourseEnrollment::whereIn('course_id', $batches)->latest();
        if(isset($_GET['course_id']) && $_GET['course_id'] >= 0){
            $students = $students->where('course_id', $_GET['course_id']);
            $data['assigned_branches'] = CourseBatch::select('branch_id')->where('teacher_id', $teacher->id)->where('branch_id', '!=', null)->distinct()->get();
//            dd(count($data['']));
        }
        if(isset($_GET['branch_id']) && $_GET['branch_id'] > 0){
            $students = $students->where('branch_id', $_GET['branch_id']);
            $data['batches'] = CourseBatch::where('teacher_id', $teacher->id)->where('course_id', $_GET['course_id'])->get();
        }
        if(isset($_GET['batch_id']) && $_GET['batch_id'] > 0){
            $students = $students->where('batch_id', $_GET['batch_id']);
        }
        if(isset($_GET['student_roll']) && $_GET['student_roll'] >= 0){
            $students = $students->where('student_roll', $_GET['student_roll']);
        }
        $data['items'] = $students->paginate(50);

        return view('teacher.student.list', $data);
    }

    public function batchCompletion($id)
    {
        $batch = CourseBatch::where('id', $id)->first();
        $batch->completion_request = 1;
        $batch->save();
        return back()->with('message', 'Batch Completion Request Submitted SuccessFully!!');
    }

    public function changeEnrollmentStatus(Request $request)
    {
//        return $request;
        $enrollment = CourseEnrollment::where('id', $request->id)->first();
        $enrollment->status = $request->status;
        $enrollment->comment = $request->comment;
        $enrollment->save();
        return back()->with('message', 'Enrollment Status Changed SuccessFully!!');
    }
}
