<?php

namespace App\Http\Controllers;

use App\Models\QustionAnswer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\AnswerMail; // Create a Mailable class

class QaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function list()
    {
        $data['faqs'] = QustionAnswer::orderBy('id', 'desc')->get();
        return view('admin.faq-qustion.list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        return view('admin.faq-qustion.form', [
            'answer' => QustionAnswer::find($id),
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        // Validate the request
        $request->validate([
            'answer' => 'required|string',
        ]);

        $answer = QustionAnswer::findOrFail($id);
        $answer->answer = $request->input('answer');
        $answer->status = 1;
        $answer->save();

        // Send the email
        Mail::to($answer->email)->send(new AnswerMail($answer));

        // Redirect or return a response
        return redirect()->route('admin.Q-A.list')->with('success', 'Answer updated and email sent successfully .');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function remove(string $id)
    {
        QustionAnswer::find($id)->delete();
        return back()->with('success','FAQ Q/A Deleted Successfully');
    }
}
