<?php

namespace App\Http\Controllers;

use App\Models\Coupon;
use App\Models\Offer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OfferController extends Controller
{
    public function add()
    {
        return view('admin.offer.form');
    }


    public function submit(Request $request)
    {
//        return $request;
        $this->validation($request);
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'coupon_code' => 'unique:coupons',
        ]);

        $coupon = new Coupon();
        $coupon->course_id          = 0;
        $coupon->type               = 2;
        $coupon->coupon_code        = $request->coupon_code;
        $coupon->discount_type      = $request->discount_type;
        $coupon->discount           = $request->discount;
        $coupon->limit_per_user     = $request->limit_per_user;
        $coupon->total_use_limit    = $request->total_use_limit;
        $coupon->expire_date        = $request->end_date;
        $coupon->description        = $request->description;
        $coupon->status             = $request->status;
        $coupon->save();

        Offer::addOrUpdate($request, $coupon->id);
        return redirect()->route('admin.offer.list')->with('message', 'Offer Has Been Added Successfully!!');
    }

    public function list()
    {
        if(Auth::check() && Auth::user()->role == 1){
            $offer = Offer::latest();

            $data['items'] = $offer->paginate(50);
            return view('admin.offer.list', $data);
        }
        else{
            $data['items'] = Offer::where('status', 1)->where('end_date', '>=', date('Y-m-d'))->latest()->paginate(10);
            return view('frontend.pages.offer.index', $data);
        }
    }

    public function detail($slug)
    {
        $data['item'] = Offer::where('slug', $slug)->first();
        if($data['item'] && $data['item']->status == 1 ){
            return view('frontend.pages.offer.detail', $data);
        }
        else{
            return redirect()->route('not-found');
        }

    }

    public function edit($id)
    {
        $data['item'] = Offer::find($id);
        $data['coupon'] = Coupon::where('id', $data['item']->coupon_id)->first();

        return view('admin.offer.form', $data);
    }

    public function update(Request $request)
    {
//        return $request;
        $this->validation($request);
        if($request->file('image')){
            $request->validate([
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
        }

        $coupon = Coupon::findOrFail($request->coupon_id);
        if($request->coupon_code != $coupon->coupon_code){
            $request->validate([
                'coupon_code' => 'unique:coupons',
            ]);
        }
        $coupon->coupon_code        = $request->coupon_code;
        $coupon->discount_type      = $request->discount_type;
        $coupon->discount           = $request->discount;
        $coupon->limit_per_user     = $request->limit_per_user;
        $coupon->total_use_limit    = $request->total_use_limit;
        $coupon->expire_date        = $request->end_date;
        $coupon->description        = $request->description;
        $coupon->status             = $request->status;
        $coupon->save();

        Offer::addOrUpdate($request, $request->coupon_id);

        return redirect()->route('admin.offer.list')->with('message', 'Offer Has Been Updated Successfully!!');
    }

    public function remove(Request $request)
    {
        $offer = Offer::findOrFail($request->id);
        Coupon::where('id', $offer->coupon_id)->delete();
        Offer::remove($request->id);
        return back()->with('message', 'Offer Has Been Removed Successfully!!');
    }
    public function validation($request){
        $request->validate([
            'title'=>['required'] ,
            'description'=>['required'] ,
            'start_date'=>['required'] ,
            'end_date'=>['required'] ,
            'course_ids'=>['required', 'array'] ,
            'coupon_code' => ['required','max:50'],
        ]);
    }
}
