<?php

namespace App\Http\Controllers;

use App\Models\CourseBatch;
use App\Models\CourseBenefit;
use App\Models\CourseCategory;
use App\Models\CourseModule;
use App\Models\CourseProject;
use App\Models\CourseResource;
use App\Models\Teacher;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\LearningContent;

class CourseController extends Controller
{
    private $course;
    public function add()
    {
        $data['categories'] = CourseCategory::where('status', 1)->orderBy('name', 'asc')->get();
        $data['teachers'] = Teacher::where('status', 1)->orderBy('name', 'asc')->get();
        return view('admin.course.form', $data);
    }


    public function submit(Request $request)
    {
//         return $request;
        $this->validation($request);
        $request->validate([
            'course_name'       =>['unique:courses'] ,
            'course_code'       =>['unique:courses', 'max:2'],
        ]);
        if(isset($request->benefit)){
            $request->validate([
                'benefit'       => ['required'],
                'thumbnail'     => ['required'],
                'description'   => ['required'],
            ]);

        }
        if($request->project > 0){
            $request->validate([
                'project_name'          => ['required', 'max:68'],
                'project_description'   => ['required'],
                'project_thumbnail'     => ['required'],
            ]);
        }
        $this->course= Course::addOrUpdate($request);
        if($request->modules != null){
            CourseModule::add($request, $this->course->id);
        }
        LearningContent::add($request, $this->course->id);
        CourseResource::add($request, $this->course->id);
        if(isset($request->benefit)){

            CourseBenefit::add($request, $this->course->id);
        }
        if($request->project != null){
            CourseProject::add($request, $this->course->id);
        }
        if(isset($request->branch_id)){
            $request->validate([
                'branch_id'     => ['required'],
                'session_id'    => ['required'],
                'teacher_id'    => ['required'],
                'batch_name'    => ['required'],
                'max_student'   => ['required'],
                'time'          => ['required'],
            ]);

            for($i=0;$i<count($request->branch_id);$i++){
                $day = 'days'.$i+1;
                $request->validate([
                    $day => ['required'],
                ]);
            }
            CourseBatch::addBatchFromCourse($request, $this->course->id);
        }

        return redirect()->route('admin.course.list')->with('message', 'Course Has Been Added Successfully!!');
    }

    public function list()
    {
        $courses = Course::latest();
        if(isset($_GET['course_status_id']) && $_GET['course_status_id'] >=0){
            $courses = $courses->where('course_status_id', $_GET['course_status_id']);
        }
        if(isset($_GET['course_type']) && $_GET['course_type']>0){
            $courses = $courses->where('course_type', $_GET['course_type']);
        }

        $data['items'] = $courses->paginate(50);

        return view('admin.course.list', $data);
    }

    public function edit($id)
    {
        $data['item'] = Course::find($id);
        $data['modules'] = CourseModule::where('course_id', $id)->latest()->get();
        $data['videos'] = CourseResource::where('course_id', $id)->where('type', 'video')->get();
        $data['discussions'] = CourseResource::where('course_id', $id)->where('type', 'discussion')->get();
        $data['notes'] = CourseResource::where('course_id', $id)->where('type', 'note')->get();
        $data['learning_outcomes'] = LearningContent::where('course_id', $id)->where('topic', 'course_outcome')->get();
        $data['software_learning'] = LearningContent::where('course_id', $id)->where('topic', 'software_learning')->get();
        $data['categories'] = CourseCategory::where('status', 1)->orderBy('name', 'asc')->get();
        $data['projects'] = CourseProject::where('course_id', $id)->get();
        $data['benefits'] = CourseBenefit::where('course_id', $id)->get();
        $data['teachers'] = Teacher::where('status', 1)->orderBy('name', 'asc')->get();
        $data['batches'] = CourseBatch::where('course_id', $id)->get();
        return view('admin.course.form', $data);
    }

    public function update(Request $request)
    {
//        return $request;
        $request->validate([
            'course_name'=>['required'] ,
            'course_code'=>['required'],
            'total_lectures'=>['required'],
            'course_duration'=>['required'],
            'course_type'=>['required'],

        ]);

        if(isset($request->benefit)){
            $request->validate([
                'benefit'       => ['required'],
                'thumbnail'     => ['required'],
                'description'   => ['required'],
            ]);

        }
//        dd('ok');
        if($request->projects){
            $total_project = count($request->projects);
        }
        else{
            $total_project = 0;
        }
        if($request->project && ($request->project - $total_project  > 0)){
            $request->validate([
                'project_name'          => ['required', 'max:68'],
                'project_description'   => ['required'],
                'project_thumbnail'     => ['required'],
            ]);
        }
        Course::addOrUpdate($request);
//        if($request->modules != null){
            CourseModule::updateModule($request);
//        }
        LearningContent::change($request);
        CourseResource::change($request);

        if(isset($request->benefits)){
            $removalable_benefits = CourseBenefit::where('course_id', $request->id)->whereNotIn('id', $request->benefits)->get();
//            dd($removalable_benefits);
            foreach ($removalable_benefits as $benefit){
                if (file_exists($benefit->thumbnail)) {
                    unlink($benefit->thumbnail);
                }
                $benefit->delete();
            }
            CourseBenefit::change($request);
        }
        if(isset($request->benefit)){
            CourseBenefit::add($request, $request->id);
        }
        if($request->projects != null){
            foreach (CourseProject::where('course_id', $request->id)->whereNotIn('id', $request->projects)->get() as $project){
                if (file_exists($project->thumbnail)) {
                    unlink($project->thumbnail);
                }
                $project->delete();
            }
            CourseProject::change($request);
        }
        if(isset($request->project)){
            CourseProject::add($request, $request->id);
        }
        if(isset($request->branch_id)){
            $request->validate([
                'branch_id'     => ['required'],
                'session_id'    => ['required'],
                'teacher_id'    => ['required'],
                'batch_name'    => ['required'],
                'max_student'   => ['required'],
                'time'          => ['required'],
            ]);

            for($i=0;$i<count($request->branch_id);$i++){
                $day = 'days'.$i+1;
                $request->validate([
                    $day => ['required'],
                ]);
            }
            CourseBatch::updateBatchFromCourse($request, $request->id);
        }
//        else
        return redirect()->route('admin.course.list')->with('message', 'Course Information Has Been Update Successfully!!');
    }

    public function remove(Request $request)
    {
        CourseModule::remove($request->id);
        CourseResource::remove($request->id);
        LearningContent::remove($request->id);
        CourseBenefit::remove($request->id);
        CourseProject::remove($request->id);
        Course::remove($request->id);
        return back()->with('message', 'Course Has Been Removed Successfully!!');
    }
    public function validation($request){
        $request->validate([
            'course_name'       =>['required'] ,
            'course_code'       =>['required'],
            'total_lectures'    =>['required'],
            'intro_video'       =>['required'],
            'course_duration'   =>['required'],
            'course_type'       =>['required'],
            'image'             =>['required'],
            'project'           => ['required']
        ]);
    }

    public function getCourse()
    {
       return response()->json(getCourseById($_GET['course_id']));
    }

}
