<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\Certificate;
use App\Models\Course;
use App\Models\CourseBatch;
use App\Models\CourseEnrollment;
use App\Models\Session;
use App\Models\Student;
use App\Models\Teacher;
use Illuminate\Http\Request;

class CourseBatchController extends Controller
{
    public function add()
    {
        $data['teachers'] = Teacher::where('status', 1)->get();
        $data['courses'] = Course::where('course_status_id', 1)->orderBy('course_name', 'asc')->get();
        $data['sessions'] = Session::where('session_status_id', 1)->orderBy('session_name', 'asc')->get();
        $data['branches'] = Branch::where('branch_status_id', 1)->orderBy('branch_name', 'asc')->get();
        return view('admin.batch.form', $data);
    }

    public function submit(Request $request)
    {
        $this->validation($request);
        $request->validate([
            'batch_name' => ['unique:course_batches'],
        ]);
        CourseBatch::addOrUpdate($request);
        return redirect()->route('batch.list')->with('message', 'Batch Added Successfully!!');
    }

    public function list()
    {
        $batch = CourseBatch::latest();
        if(isset($_GET['course_id']) && $_GET['course_id'] > 0){
            $batch->where('course_id', $_GET['course_id']);
        }
        if (isset($_GET['teacher_id']) && $_GET['teacher_id'] > 0){
            $batch->where('teacher_id', $_GET['teacher_id']);
        }
        $data['items'] = $batch->get();
        $data['teachers'] = Teacher::orderBy('name', 'asc')->get();
        return view('admin.batch.list', $data);
    }
    public function edit($id)
    {
        $data['item'] = CourseBatch::find($id);
        $data['teachers'] = Teacher::where('status', 1)->get();
        $data['sessions'] = Session::where('session_status_id', 1)->orderBy('session_name', 'asc')->get();
        $data['courses'] = Course::where('course_status_id', 1)->orderBy('course_name', 'asc')->get();
        return view('admin.batch.form', $data);
    }
    public function update(Request $request)
    {
        $this->validation($request);
        CourseBatch::addOrUpdate($request);
        return redirect()->route('batch.list')->with('message', 'Batch Updated Successfully!!');
    }
    public function remove(Request $request)
    {
        CourseBatch::remove($request->id);
        return redirect()->route('batch.list')->with('message', 'Batch Removed Successfully!!');
    }

    public function validation($request)
    {
        $request->validate([
            'batch_name'    => ['required'],
            'branch_id'     => ['required'],
            'course_id'     => ['required'],
            'session_id'    => ['required'],
            'teacher_id'    => ['required'],
            'max_student'   => ['required'],
            'time'          => ['required'],
            'days'          => ['required', 'array']
        ]);
    }

    public function completionRequest()
    {
        $data['items'] = CourseBatch::where('completion_request', 1)->where('status', 1)->orderBy('created_at', 'desc')->get();
        $data['teachers'] = Teacher::where('status', 1)->get();
        $data['courses'] = Course::where('course_status_id', 1)->orderBy('course_name', 'asc')->get();
        $data['sessions'] = Session::where('session_status_id', 1)->orderBy('session_name', 'asc')->get();
        return view('admin.batch.completion_request', $data);
    }
    public function completionStatusChange(Request $request)
    {
//        return $request;
        $batch = CourseBatch::where('id', $request->id)->first();
        $branch = Branch::where('branch_id', $batch->branch_id)->first();
        if($request->status == 1){
            $batch->status = 3;
            $batch->completion_request = 2;

            CourseEnrollment::where('batch_id', $batch->id)->update([
                'status' => 3,
                'certificate_provided' => 1,
            ]);

            foreach (CourseEnrollment::where('batch_id', $batch->id)->get() as $courseEnrollment) {
                $student = Student::where('id', $courseEnrollment->student_id)->first();
                if($student){
                    $certificate = new Certificate();
                    $certificate->name =$student->student_name;
                    $certificate->father_name = $student->father_name;
                    $certificate->mother_name = $student->mother_name;
                    $certificate->student_roll = $student->branchStudent->student_roll ?? '';
                    $certificate->student_registration_num = $student->branchStudent->student_registration ?? '';
                    $certificate->course_name = $batch->course->course_name;
                    $certificate->batch_name = $batch->batch_name;
                    $certificate->branch_name = $branch->branch_name ?? '';
                    $certificate->start_date = $batch->course->start_date ?? '';
                    $certificate->end_date = date('Y-m-d');
                    $certificate->teacher_name = $batch->teacher->name ?? '';
                    $certificate->serial_num = date('ym').$student->id.$batch->course_id.$batch->id;
                    $certificate->save();

                }

            }

        }
        else{
            $batch->completion_request = 0;
        }
        $batch->save();
        return back()->with('message', 'Batch Status Changed Successfully!!');
    }

    public function removeExistingBatch()
    {
        CourseBatch::where('id', $_GET['id'])->delete();
        return response()->json(true);
    }


}
