<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerPackage;
use Session;
use URL;

class BkashController extends Controller
{
    private $base_url;
    public function __construct()
    {
        if(env('BKASH_SANDBOX_MODE')==1){
            $this->base_url = "https://tokenized.sandbox.bka.sh/v1.2.0-beta/tokenized/";
        }
        else {
            $this->base_url = "https://tokenized.pay.bka.sh/v1.2.0-beta/tokenized/";
        }
    }

    public function pay(){
        $amount = 0;
        if(Session::has('payment_amount')){
            $amount = round(Session::get('payment_amount'));
        }
        
        //return view('frontend.bkash.index');
        
        return $this->checkout();
    }
    
    public function auth(){
        $request_data = array('app_key'=> env('BKASH_CHECKOUT_APP_KEY'), 'app_secret'=>env('BKASH_CHECKOUT_APP_SECRET'));
        $request_data_json=json_encode($request_data);

        $header = array(
                'Content-Type:application/json',
                'username:'.env('BKASH_CHECKOUT_USER_NAME'),
                'password:'.env('BKASH_CHECKOUT_PASSWORD')
                );
        
        $url = curl_init($this->base_url.'checkout/token/grant');
        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_POSTFIELDS, $request_data_json);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

        $resultdata = curl_exec($url);
        curl_close($url);

        //dd($resultdata);
        $token = json_decode($resultdata)->id_token;
        return $token;
    }

    public function checkout(){
        Session::forget('bkash_token');
        Session::put('bkash_token', $this->auth());
        $auth = Session::get('bkash_token');
        //dd($auth);
        
        $website_url = URL::to("/");
        
        //dd($website_url);
        
        $requestbody = array(
            'mode' => '0011',
            'payerReference' => ' ',
            'callbackURL' => $website_url.'/bkash/callback',
            'amount' => Session::get('payment_amount'),
            'currency' => 'BDT',
            'intent' => 'sale',
            'merchantInvoiceNumber' => Session::get('invoice_no')
        );
        $requestbodyJson = json_encode($requestbody);
        $header = array(
            'Content-Type:application/json',
            'Authorization:' . $auth,
            'X-APP-Key:'.env('BKASH_CHECKOUT_APP_KEY')
        );

        $url = curl_init($this->base_url.'checkout/create');
        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $requestbodyJson);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $resultdata = curl_exec($url);
        curl_close($url);
        
        //dd($resultdata);
        
        if(json_decode($resultdata)->bkashURL){
            return redirect((json_decode($resultdata)->bkashURL));
        }
        
        return redirect()->back()->with('error', 'bKash Payment Failed!');
        

        //return $resultdata;
    }
    
    public function callback(Request $request)
    {
        // dd($request);
        $allRequest = $request->all();
        //dd($allRequest);
        // Check if the payment status is failure
        if(isset($allRequest['status']) && $allRequest['status'] == 'failure') {
            //dd($allRequest);
            return back()->with('error', 'Payment failed!');
        }elseif (isset($allRequest['status']) && $allRequest['status'] == 'cancel') {
            // Check if the payment status is cancel
            // dd($request);
            
            return back()->with('error', 'Payment canceled!');
    
        }else {
            // Execute the payment and handle the result
            $resultdata = $this->execute($allRequest['paymentID']);
            // dd($resultdata);
            Session::forget('payment_details');
            Session::put('payment_details', $resultdata);
    
            $result_data_array = json_decode($resultdata, true);
    
            if(array_key_exists("statusCode", $result_data_array) && $result_data_array['statusCode'] != '0000') {
                //dd('okk');
                // Handle error status code
                
                
                return back()->with('error', $result_data_array['statusMessage']);

            }elseif (array_key_exists("message", $result_data_array)) {
                //dd('not okk');
                // Handle other cases, such as additional processing if there's a message
                sleep(1);
                $resultdata = $this->query($allRequest['paymentID']);
                Session::forget('payment_details');
                Session::put('payment_details', $resultdata);
            }
            
            
            if(array_key_exists("statusCode", $result_data_array) && $result_data_array['statusCode'] == '0000') {
                //dd('all okk');
                
                // $checkout_request = new Request;
                // $checkout_request = new Request(Session::get('checkout_request'));
                // $checkout_request->payment_info = Session::get('payment_details');
                // $checkout = new CourseEnrollmentController;
                
                // $notification = array(
                //     'message' => 'Payment Successfull!', 
                //     'alert-type' => 'Congratulations'
                // );
                return redirect()->route('bkash.success');
            }
            
            return redirect()->route('bkash.success');
        }
    }


    public function execute($paymentID){
        //$paymentID = $request->paymentID;
        $auth = Session::get('bkash_token');

        $requestbody = array(
            'paymentID' => $paymentID
        );
        $requestbodyJson = json_encode($requestbody);
        //dd($requestbodyJson);

        $header = array(
            'Content-Type:application/json',
            'Authorization:' . $auth,
            'X-APP-Key:'.env('BKASH_CHECKOUT_APP_KEY')
        );

        $url = curl_init($this->base_url.'checkout/execute');
        //dd($url);
        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $requestbodyJson);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $resultdata = curl_exec($url);
        //dd($resultdata);
        curl_close($url);

        return $resultdata;
    }
    
    
    public function refund($paymentID){
        $auth = Session::get('bkash_token');

        $requestbody = array(
            'paymentID' => $paymentID
        );
        
        $requestbodyJson = json_encode($requestbody);

        $header = array(
            'Content-Type:application/json',
            'Authorization:' . $auth,
            'X-APP-Key:'.env('BKASH_CHECKOUT_APP_KEY')
        );

        $url = curl_init($this->base_url.'checkout/execute');
        //dd($url);
        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $requestbodyJson);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $resultdata = curl_exec($url);
        curl_close($url);

        return $resultdata;
    }

    public function success(){
        $checkout_request = new Request;
        $checkout_request = new Request(Session::get('checkout_request'));
        $checkout_request->payment_info = Session::get('payment_details');
        $checkout_request->invoice_no = Session::get('invoice_no');
        $checkout = new CourseEnrollmentController;
        
        return $checkout->store($checkout_request);
    }

    public function error(Request $request){
         $notification = array(
            'message' => 'Payment failed!.', 
            'alert-type' => 'error'
        );
        return redirect()->route('checkout')->with($notification);
    }
}